 ; Ŀ
 ;   Sun - directly access entity and subentity data.                      
 ;   Copyright 1994, 1995, 1997, 1998, 2001, 2004 by Rocket Software Ltd.  
 ;   Like X-ray Specs - you can't be sure which level you're looking at.   
 ; 

 ; Ŀ
 ;   Subroutine Dena - show the nesting on an entity.                      
 ;   Takes one argument, the list returned by nentsel.                     
 ;   Prints a list.                                                        
 ; 
 (DEFUN DENA (aa / enam str)
  (setq aa (reverse (car (reverse aa))))
  (if (= (type (car aa)) 'ENAME)
      (progn
           (while (setq enam (car aa))
           (setq aa (cdr aa))
           (if str
              (setq str (strcat str ">" (cdr (assoc 2 (entget enam)))))
              (setq str (strcat "\nNesting: " (cdr (assoc 2 (entget enam)))))))
           (write-line str)))
 (princ))
 ; Ŀ
 ;   Dena end.                                                             
 ; 

 ; Ŀ
 ;   Sun.                                                                  
 ; 
 (DEFUN C:SUN (/ aa str nxnam ntt)
 ; Ŀ
 ;   If no previous entity was selected, get one, print its data list,     
 ;   highlight it, print its nesting.                                      
 ; 
  (if (/= (type enam) 'ENAME)
      (progn
            (while (null aa) (setq aa (nentsel "Select entity:")))
            (print (entget (setq enam (car aa))))
            (redraw enam 3)
            (dena aa))
 ; Ŀ
 ;   If an entity was already selected, get a new one, redraw the old.     
 ; 
      (progn
            (redraw enam)
            (setq aa (nentsel "Select entity or <Return> for next."))
            (setq nxnam (car aa))
 ; Ŀ
 ;   If a new entity was selected then print its data and highlight it.    
 ; 
            (if nxnam
                (progn
                      (setq enam (cdar (print (entget nxnam))))
                      (redraw enam 3)
                      (dena aa))
 ; Ŀ
 ;   If the new input was a Return then get the next entity, list etc.     
 ; 
                (progn
                      (if (setq ntt (entnext enam))
                          (progn
                                (setq enam (cdar (print (entget ntt))))
                                (redraw enam 3))
                          (write-line "There are no more entities."))))))
 (princ))